package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bTiposVoces;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bTiposVocesBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaTiposVocesExcelAction.
 *
 * @author jrgil
 */
public class W83bTablaTiposVocesExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		W83bTiposVocesBean tiposVocesBean = (W83bTiposVocesBean)contexto.get("w83bTiposVocesBean");
		contexto.set("w83bTiposVocesTempBean",tiposVocesBean);
	}
	
	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoTiposVoces.xls";
		InputStream inputStream = W83bTablaTiposVocesExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaTiposVoces = (ArrayList)contexto.get("w83bListaTiposVoces");
        W83bTiposVocesBean tiposVocesBean = (W83bTiposVocesBean)contexto.get("w83bTiposVocesTempBean");                 
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                 
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                 
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                 
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                 
        HashMap mapaTiposVoces=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                 
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1                 
        HSSFCell cell = row.createCell((short)3);                 
        row = sheet.getRow((short)4);                 
        cell = row.getCell((short)3);                 
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaTiposVoces.get("tituloDepEs");                 
        StringBuffer tituloImagenEu =  (StringBuffer)mapaTiposVoces.get("tituloDepEu");                 
        cell.setCellValue(tituloImagenEu.toString());                 
        
        cell = row.getCell((short)6);                 
        cell.setCellValue(tituloImagenEs.toString());                 
        
        tituloImagenEs = (StringBuffer)mapaTiposVoces.get("tituloDelelegacionEs");                 
        tituloImagenEu = (StringBuffer)mapaTiposVoces.get("tituloDelelegacionEu");                 
        
        row = sheet.getRow((short)6);                 
        cell = row.getCell((short)3);                 
        cell.setCellValue(tituloImagenEu.toString());                 
        
        cell = row.getCell((short)6);                 
        cell.setCellValue(tituloImagenEs.toString());                 
        
        row = sheet.getRow((short)9);                 
        cell = row.getCell((short)0);                 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.listadoTiposVoces").toUpperCase());                 
        
        //MAPEO FORMULARIO
      //fila 10, columna 2 y 3
        row = sheet.getRow(Short.parseShort("12"));
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.codTiposVocesBusqueda"));
        cell = row.createCell(Short.parseShort("3"));
        if(!StringUtils.isEmpty(tiposVocesBean.getCodTipoVoz().toUpperCase())){
        	cell.setCellValue(W83bUtilidades.numero(tiposVocesBean.getCodTipoVoz().toUpperCase()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.baja"));        
        cell = row.createCell(Short.parseShort("8"));
        if(StringUtils.isEmpty(tiposVocesBean.getBaja())||W83bClsConstantes.CONSTANTE_NO.equals(tiposVocesBean.getBaja())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
       	
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
 	        	
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
      
      //fila 11, columna 2 y 3
        row = sheet.getRow(Short.parseShort("13"));
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.descTiposVocesCastBusq"));
        cell = row.createCell(Short.parseShort("3"));
        if(StringUtils.isNotEmpty(tiposVocesBean.getDescTipoVoz())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("3"),W83bClsConstantes.TRECE,Short.parseShort("5")));//NOPMD
        	cell.setCellValue(tiposVocesBean.getDescTipoVoz().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.descTiposVocesEuskBusq"));       
        cell = row.createCell(Short.parseShort("8"));
        if(StringUtils.isNotEmpty(tiposVocesBean.getDescTipoVozEusk())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("8"),W83bClsConstantes.TRECE,Short.parseShort("10")));//NOPMD
        	cell.setCellValue(tiposVocesBean.getDescTipoVozEusk().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        if(StringUtils.isNotEmpty(tiposVocesBean.getDescTipoVoz()) && StringUtils.isNotEmpty(tiposVocesBean.getDescTipoVozEusk())){
	        if(tiposVocesBean.getDescTipoVoz().length()>tiposVocesBean.getDescTipoVozEusk().length()){
		    	if(51<tiposVocesBean.getDescTipoVoz().length()){
		    		row.setHeightInPoints((short)(20*((tiposVocesBean.getDescTipoVoz()).length()/51)+1));
		    	}
	    	}else{
	    		if(41<tiposVocesBean.getDescTipoVozEusk().length()){
			    	row.setHeightInPoints((short)(20*((tiposVocesBean.getDescTipoVozEusk()).length()/41)+1));
			    }
	    	}
        }
   
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamanyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("16")); // Creacin de la fila 15
        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 2 para la fila 15
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.codTiposVocesBusqueda"));
        
        cell = row.getCell(Short.parseShort("2")); // Creacin de la columna 3 para la fila 15
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.descTiposVocesCastBusq"));
        
        // 3 columna del titulo del listado
        cell = row.getCell(Short.parseShort("6")); // Creacin de la columna 4 para la fila 15
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.tiposVoces.descTiposVocesEuskBusq"));


        for(int i=0;i<listaTiposVoces.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECISIETE+i); // Creacin de la fila 16//NOPMD

        	//Cod TiposVoz
        	cell = row.createCell(Short.parseShort("0"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("0"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("1")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bTiposVocesBean)listaTiposVoces.get(i)).getCodTipoVoz())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bTiposVocesBean)listaTiposVoces.get(i)).getCodTipoVoz()));
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell(Short.parseShort("1")); 
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));

        	//Descripcin TiposVoz
        	cell = row.createCell(Short.parseShort("2"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("2"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("5")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVoz())){
        		cell.setCellValue(((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVoz());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("5")); 
        	cell.setCellStyle(this.estiloFila(i,excel));

        	//Descripcin TiposVozEusk
        	cell = row.createCell(Short.parseShort("6"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("6"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("10")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVozEusk())){
        		cell.setCellValue(((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVozEusk());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("7")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("9")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("10")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	if(StringUtils.isNotEmpty(((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVoz()) 
        			&& StringUtils.isNotEmpty(((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVozEusk())){
	        	if((((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVoz()).length()>=(((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVozEusk()).length()){
		        	if(75<(((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVoz()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVoz()).length()/75)+1));
		        	}
		        }else{
		        	if(78<(((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVozEusk()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bTiposVocesBean)listaTiposVoces.get(i)).getDescTipoVozEusk()).length()/78)+1));
		        	}
		        }
        	}
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoTiposVoces.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		return null;
	}
	

	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}

}
